<?php

namespace Modules\Common\AdministrativeLimits;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;

    public function admin1_codes()
    {
        return $this->hasMany('Admin1Code', 'code', 'country_code');
    }

    public function culture()
    {
        return $this->belongsTo('Culture');
    }

    public function dateFormatType()
    {
        return $this->belongsTo('DateFormatType');
    }

}